/*
 * Copyright 2008, Sergey Baranov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package amip.api.highlevel.util;

import amip.api.highlevel.exceptions.*;
import amip.api.highlevel.listeners.*;
import amip.api.wrapper.constants.Errors;
import amip.api.wrapper.constants.Events;

public class Utils {
  public static void errorToException(int err) throws GeneralClientException {
    switch (err) {
      case Errors.AC_ERR_NOERROR :
        return;
      case Errors.AC_ERR_CLIENTISNULL :
        throw new ClientNotInitializedException();
      case Errors.AC_ERR_CONNECTIONFAILED :
        throw new ConnectionFailedException();
      case Errors.AC_ERR_EXCEPTION :
        throw new ClientException();
      case Errors.AC_ERR_SERVERNOTRUNNING :
        throw new ServerNotRunningException();
    }
  }


  public static Class eventCodeToClass(int code) {
    Class eventClass = null;

    switch (code) {
      case Events.AC_EVT_CHANGE:
        eventClass = ChangeEventListener.class;
        break;
      case Events.AC_EVT_MSG:
        eventClass = MessageEventListener.class;
        break;
      case Events.AC_EVT_EXIT:
        eventClass = ExitEventListener.class;
        break;
      case Events.AC_EVT_PAUSE:
        eventClass = PauseEventListener.class;
        break;
      case Events.AC_EVT_PLAY:
        eventClass = PlayEventListener.class;
        break;
      case Events.AC_EVT_PLCHANGE:
        eventClass = PlaylistChangeEventListener.class;
        break;
      case Events.AC_EVT_PLREADY:
        eventClass = PlaylistReadyEventListener.class;
        break;
      case Events.AC_EVT_START:
        eventClass = StartEventListener.class;
        break;
      case Events.AC_EVT_STOP:
        eventClass = StopEventListener.class;
        break;
      case Events.AC_EVT_TIMER:
        eventClass = TimerEventListener.class;
        break;
    }

    return eventClass;
  }

  public static int eventClassToCode(Class c) {
    int code = -1;

    if (c == ChangeEventListener.class) {
      return Events.AC_EVT_CHANGE;
    } else if (c == MessageEventListener.class) {
      return Events.AC_EVT_MSG;
    } else if (c == ExitEventListener.class) {
      return Events.AC_EVT_EXIT;
    } else if (c == PauseEventListener.class) {
      return Events.AC_EVT_PAUSE;
    } else if (c == PlayEventListener.class) {
      return Events.AC_EVT_PLAY;
    } else if (c == PlaylistChangeEventListener.class) {
      return Events.AC_EVT_PLCHANGE;
    } else if (c == PlaylistReadyEventListener.class) {
      return Events.AC_EVT_PLREADY;
    } else if (c == StartEventListener.class) {
      return Events.AC_EVT_START;
    } else if (c == StopEventListener.class) {
      return Events.AC_EVT_STOP;
    } else if (c == TimerEventListener.class) {
      return Events.AC_EVT_TIMER;
    }

    return code;
  }
}
