/*
 * Copyright 2008, Sergey Baranov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package amip.api.highlevel.util;

/**
 * @noinspection SynchronizeOnThis
 */
public class Semaphore {
  private int counter;

  public Semaphore() {
    this(0);
  }

  public Semaphore(int i) {
    if (i < 0) throw new IllegalArgumentException(i + " < 0");
    counter = i;
  }

  /**
   * Increments internal counter, possibly awakening a thread wait()ing in acquire().
   */
  public synchronized void release() {
    if (counter == 0) {
      notifyAll();
    }
    counter++;
  }

  /**
   * Decrements internal counter, blocking if the counter is already zero.
   *
   * @throws InterruptedException passed from this.wait().
   * @noinspection WhileLoopSpinsOnField
   */
  public synchronized void acquire() throws InterruptedException {
    while (counter == 0) {
      wait();
    }
    counter--;
  }
}
