package amip.api.examples.lowlevel;

import amip.api.wrapper.AMIPAPI;

/**
 * Test for the JNI method providing file version information (read from the exe/dll resources).
 * This method can be used to find if AMIP requires updating (used in IdeaAmp plug-in).
 */
public class ShowFileVersion {
  public static void main(String[] args) {
    if(args.length < 1) {
      System.out.println("Usage: ShowFileVersion <exe or dll file name>");
      return;
    }
    String path = args[0];
    String version = AMIPAPI.get_file_version(path);
    System.out.println("Reading version information from: " + path);
    System.out.println("Version: " + version);
  }
}
