/*
 * Copyright 2008, Sergey Baranov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package amip.api.examples.highlevel;

import amip.api.highlevel.Client;

/**
 * Displays now playing song information using the high-level Java-style API.
 */
public class ShowNowPlaying {
  public static void main(String[] args) {
    Client cl = Client.getInstance();
    try {
      cl.init();
      String name = cl.format("%name");
      System.out.println("Now playing: " + name);
    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      cl.uninit();
    }
  }
}
