/*
 * Copyright 2008, Sergey Baranov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package amip.api.examples.highlevel;

import amip.api.highlevel.Client;
import amip.api.highlevel.exceptions.GeneralClientException;
import amip.api.highlevel.exceptions.ClientInitializationFailedException;

/** @noinspection NonConstantStringShouldBeStringBuffer*/
public class ApiExec {
  public static void main(String[] args) throws GeneralClientException, ClientInitializationFailedException {
    if (args.length == 0) {
      System.out.println("You must specify AMIP API command to execute");
      return;
    }

    String cmd = "";

    for (int i = 0; i < args.length; i++) {
      String arg = args[i];
      cmd += arg;
      if(i != args.length -1) cmd += " ";
    }

    System.out.println("Executing API command: " + cmd);

    final Client c = Client.getInstance();
    c.init();
    c.execute(cmd);
    c.uninit();
  }
}
