/*
 * Copyright 2008, Sergey Baranov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package amip.api.examples.lowlevel;

import amip.api.wrapper.AMIPAPI;
import amip.api.wrapper.constants.Errors;

/**
 * The most simple example possible, using the raw low-level API contacts with AMIP server running on the localhost port
 * 60333 and displays song name currently playing in your player.
 */
public class ShowNowPlaying {
  public static void main(String[] args) {
    AMIPAPI.init_client("127.0.0.1", 60333, 5000, 5, 1);
    String name = AMIPAPI.eval("var_name");
    int last_error = AMIPAPI.get_last_error();
    if (Errors.AC_ERR_NOERROR == last_error) {
      System.out.println("Now playing: " + name);
    } else {
      System.out.println("Error code: " + last_error);
    }
    AMIPAPI.uninit_client();
  }
}
