/*
 * Copyright 2008, Sergey Baranov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package amip.api.examples.highlevel;

import amip.api.highlevel.Client;

import java.util.Arrays;

public class EvalString {
  public static void main(String[] args) {
    if(args.length < 1) {
      System.err.println("Usage: EvalString <format string>");
      System.exit(1);
    }

    String allargs = "";
    for (int i = 0; i < args.length; i++) {
      String arg = args[i];
      allargs += arg + " ";
    }

    allargs = allargs.trim();

    System.out.println("Expression: " + allargs);

    Client cl = Client.getInstance();
    try {
      cl.init();
      String str = cl.format(allargs);
      System.out.println("Result:     " + str);
    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      cl.uninit();
    }
  }
}
