/*
 * Decompiled with CFR 0.152.
 */
package amip.api.examples.highlevel;

import amip.api.highlevel.Client;
import amip.api.highlevel.Config;
import amip.api.highlevel.EventListenerManager;
import amip.api.highlevel.Server;
import amip.api.highlevel.exceptions.ClientInitializationFailedException;
import amip.api.highlevel.exceptions.GeneralClientException;
import amip.api.highlevel.exceptions.ServerStartupFailedException;
import amip.api.highlevel.listeners.MessageEventListener;
import amip.api.highlevel.util.Semaphore;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DumpVariables {
    private static final Semaphore ourSem = new Semaphore();
    private static Map ourMap = new TreeMap();

    public static void main(String[] args) throws ClientInitializationFailedException, ServerStartupFailedException, GeneralClientException, InterruptedException {
        Client c = Client.getInstance();
        Server s = Server.getInstance();
        c.init();
        s.start();
        EventListenerManager manager = s.getEventListenersManager();
        manager.addMessageEventListener(new MessageEventListener(){

            public void messageReceived(String msg) {
                DumpVariables.parseMessage(msg);
            }
        });
        Config config = c.getConfig();
        String oldoutput = config.getOption("cmdstr");
        System.out.println("oldoutput = " + oldoutput);
        String oldtransports = config.getOption("disabletransports");
        config.setOption("cmdstr", "");
        config.setOption("disabletransports", "1");
        c.execute("dump");
        ourSem.acquire();
        Set set = ourMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String val = (String)ourMap.get(key);
            if (val.length() == 0) {
                val = "(empty)";
            }
            val = val.replaceAll("\r\n", "\\\\n");
            System.out.println(key + " = " + val);
        }
        config.setOption("cmdstr", oldoutput == null ? "" : oldoutput);
        config.setOption("disabletransports", oldtransports);
        manager.removeAllEventListeners();
        c.uninit();
        s.stop();
    }

    private static void parseMessage(String msg) {
        if (msg.startsWith(">")) {
            if ((msg = msg.substring(1)).equalsIgnoreCase("=DUMP_END=")) {
                ourSem.release();
            } else {
                String[] parts = msg.split(" => ");
                if (parts.length == 2) {
                    String val = parts[1];
                    val = val.substring(1, val.length() - 1);
                    ourMap.put(parts[0], val);
                }
            }
        }
    }
}

