/*
 * Decompiled with CFR 0.152.
 */
package amip.api.highlevel.util;

import amip.api.highlevel.exceptions.ClientException;
import amip.api.highlevel.exceptions.ClientNotInitializedException;
import amip.api.highlevel.exceptions.ConnectionFailedException;
import amip.api.highlevel.exceptions.GeneralClientException;
import amip.api.highlevel.exceptions.ServerNotRunningException;
import amip.api.highlevel.listeners.ChangeEventListener;
import amip.api.highlevel.listeners.ExitEventListener;
import amip.api.highlevel.listeners.MessageEventListener;
import amip.api.highlevel.listeners.PauseEventListener;
import amip.api.highlevel.listeners.PlayEventListener;
import amip.api.highlevel.listeners.PlaylistChangeEventListener;
import amip.api.highlevel.listeners.PlaylistReadyEventListener;
import amip.api.highlevel.listeners.StartEventListener;
import amip.api.highlevel.listeners.StopEventListener;
import amip.api.highlevel.listeners.TimerEventListener;

public class Utils {
    public static void errorToException(int err) throws GeneralClientException {
        switch (err) {
            case 0: {
                return;
            }
            case 1: {
                throw new ClientNotInitializedException();
            }
            case 3: {
                throw new ConnectionFailedException();
            }
            case 2: {
                throw new ClientException();
            }
            case 4: {
                throw new ServerNotRunningException();
            }
        }
    }

    public static Class eventCodeToClass(int code) {
        Class eventClass = null;
        switch (code) {
            case 128: {
                eventClass = ChangeEventListener.class;
                break;
            }
            case 64: {
                eventClass = MessageEventListener.class;
                break;
            }
            case 16: {
                eventClass = ExitEventListener.class;
                break;
            }
            case 2: {
                eventClass = PauseEventListener.class;
                break;
            }
            case 1: {
                eventClass = PlayEventListener.class;
                break;
            }
            case 256: {
                eventClass = PlaylistChangeEventListener.class;
                break;
            }
            case 512: {
                eventClass = PlaylistReadyEventListener.class;
                break;
            }
            case 8: {
                eventClass = StartEventListener.class;
                break;
            }
            case 4: {
                eventClass = StopEventListener.class;
                break;
            }
            case 32: {
                eventClass = TimerEventListener.class;
            }
        }
        return eventClass;
    }

    public static int eventClassToCode(Class c) {
        int code = -1;
        if (c == ChangeEventListener.class) {
            return 128;
        }
        if (c == MessageEventListener.class) {
            return 64;
        }
        if (c == ExitEventListener.class) {
            return 16;
        }
        if (c == PauseEventListener.class) {
            return 2;
        }
        if (c == PlayEventListener.class) {
            return 1;
        }
        if (c == PlaylistChangeEventListener.class) {
            return 256;
        }
        if (c == PlaylistReadyEventListener.class) {
            return 512;
        }
        if (c == StartEventListener.class) {
            return 8;
        }
        if (c == StopEventListener.class) {
            return 4;
        }
        if (c == TimerEventListener.class) {
            return 32;
        }
        return code;
    }
}

