/*
 * Decompiled with CFR 0.152.
 */
package amip.api.highlevel;

import amip.api.highlevel.EventListenerManager;
import amip.api.highlevel.exceptions.ServerStartupFailedException;
import amip.api.wrapper.AMIPAPI;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;

public class Server {
    private static Server ourInstance = null;
    private EventListenerManager ourEventListenerManager = null;
    private String bindAddress = "127.0.0.1";
    private String externalAddress = null;
    private boolean started = false;
    private int port = 60334;
    private static final int PORT_MIN = 60334;
    private static final int PORT_MAX = 60666;

    private Server() {
    }

    public void start(String bindAddress, int port) throws ServerStartupFailedException {
        this.bindAddress = bindAddress;
        this.port = port;
        this.start();
    }

    public void start() throws ServerStartupFailedException {
        int res = AMIPAPI.init_server(this.bindAddress, this.port);
        if (res == 0) {
            throw new ServerStartupFailedException();
        }
        this.started = true;
    }

    public void stop() {
        if (this.started) {
            AMIPAPI.stop_server();
        }
        this.started = false;
    }

    private static synchronized void createInstance() {
        if (ourInstance == null) {
            ourInstance = new Server();
        }
    }

    public static synchronized Server getInstance() {
        if (ourInstance == null) {
            Server.createInstance();
        }
        return ourInstance;
    }

    public EventListenerManager getEventListenersManager() {
        if (this.ourEventListenerManager == null) {
            this.ourEventListenerManager = new EventListenerManager();
        }
        return this.ourEventListenerManager;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isStarted() {
        return this.started;
    }

    public String getExternalAddress() {
        if (this.externalAddress == null) {
            if (this.bindAddress.compareTo("0.0.0.0") == 0) {
                return null;
            }
            return this.bindAddress;
        }
        return this.externalAddress;
    }

    public void setExternalAddress(String externalAddress) {
        this.externalAddress = externalAddress;
    }

    public static int findFreePort() {
        InetAddress[] interfaces = Server.getNetworkInterfaces();
        return Server.findFreePort(interfaces);
    }

    public static int findFreeLocalPort() {
        try {
            return Server.findFreePort(new InetAddress[]{InetAddress.getByName("127.0.0.1")});
        }
        catch (UnknownHostException e) {
            return -1;
        }
    }

    public static int findFreePort(String iface) {
        if (iface.compareTo("0.0.0.0") == 0) {
            return Server.findFreePort();
        }
        try {
            return Server.findFreePort(new InetAddress[]{InetAddress.getByName(iface)});
        }
        catch (UnknownHostException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findRandomPort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findFreePort(InetAddress[] interfaces) {
        for (int i = 60334; i < 60666; ++i) {
            boolean failed = false;
            for (int j = 0; j < interfaces.length; ++j) {
                InetAddress ia = interfaces[j];
                ServerSocket socket = null;
                try {
                    socket = new ServerSocket(i, 50, ia);
                    continue;
                }
                catch (IOException e) {
                    failed = true;
                    break;
                }
                finally {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            if (failed) continue;
            return i;
        }
        return -1;
    }

    private static InetAddress[] getNetworkInterfaces() {
        ArrayList<InetAddress> ifaces = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface netif = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = netif.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    ifaces.add(inetAddress);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return ifaces.toArray(new InetAddress[ifaces.size()]);
    }
}

