/*
 * Decompiled with CFR 0.152.
 */
package amip.api.highlevel;

import amip.api.highlevel.Server;
import amip.api.highlevel.exceptions.GeneralClientException;
import amip.api.highlevel.listeners.AEventListener;
import amip.api.highlevel.listeners.MessageEventListener;
import amip.api.highlevel.util.AEventListenerList;
import amip.api.highlevel.util.Utils;
import amip.api.wrapper.AMIPAPI;
import amip.api.wrapper.callbacks.EventCallback;
import amip.api.wrapper.callbacks.MessageCallback;
import java.util.EventListener;

public class EventListenerManager {
    private AEventListenerList listenerList = new AEventListenerList();
    private int timeout = 5000;
    private int retries = 5;
    static final /* synthetic */ boolean $assertionsDisabled;

    EventListenerManager() {
    }

    public int getListenerCount() {
        return this.listenerList.getListenerCount();
    }

    public void addEventListener(AEventListener l) throws GeneralClientException {
        Class<?> aClass = l.getClass().getInterfaces()[0];
        if (AMIPAPI.evtCallback == null) {
            AMIPAPI.setEvtCallback(new EventCallback(){

                public void process(int mode) {
                    EventListenerManager.this.fireEvent(mode);
                }
            });
        }
        this.listenerList.addListener(aClass, l);
    }

    public void removeEventListener(AEventListener l) throws GeneralClientException {
        this.listenerList.removeListener(l.getClass(), l);
    }

    public void addMessageEventListener(MessageEventListener l) throws GeneralClientException {
        if (AMIPAPI.msgCallback == null) {
            AMIPAPI.setMsgCallback(new MessageCallback(){

                public void process(String message) {
                    EventListenerManager.this.fireMessageEvent(message);
                }
            });
        }
        this.listenerList.addListener(MessageEventListener.class, l);
    }

    public void removeMessageEventListener(MessageEventListener l) throws GeneralClientException {
        this.listenerList.removeListener(MessageEventListener.class, l);
    }

    public void removeAllEventListeners() throws GeneralClientException {
        if (this.getListenerCount() > 0) {
            int res = AMIPAPI.remove_event_listener(Server.getInstance().getExternalAddress(), Server.getInstance().getPort());
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.listenerList.remove((Class)listeners[i], (EventListener)listeners[i + 1]);
            }
            this.listenerList.setMode(0);
            if (!$assertionsDisabled && this.listenerList.getListenerCount() != 0) {
                throw new AssertionError();
            }
            Utils.errorToException(res);
        }
    }

    public void fireMessageEvent(String msg) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$amip$api$highlevel$listeners$MessageEventListener == null ? EventListenerManager.class$("amip.api.highlevel.listeners.MessageEventListener") : class$amip$api$highlevel$listeners$MessageEventListener)) continue;
            ((MessageEventListener)listeners[i + 1]).messageReceived(msg);
        }
    }

    public void fireEvent(int code) {
        Class eventClass = Utils.eventCodeToClass(code);
        this.fireEvent(eventClass);
    }

    public void fireEvent(Class eventClass) {
        if (eventClass == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != eventClass) continue;
            ((AEventListener)listeners[i + 1]).eventReceived();
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    static {
        $assertionsDisabled = !EventListenerManager.class.desiredAssertionStatus();
    }
}

