/*
 * Decompiled with CFR 0.152.
 */
package amip.api.highlevel;

import amip.api.highlevel.Client;
import amip.api.highlevel.EventListenerManager;
import amip.api.highlevel.Server;
import amip.api.highlevel.exceptions.GeneralClientException;
import amip.api.highlevel.listeners.MessageEventListener;
import amip.api.highlevel.util.Semaphore;
import java.util.Map;
import java.util.TreeMap;

public class Config {
    public static final String DUMP_END = "=DUMP_END=";
    public static final String OUTPUT_COMMAND = "cmdstr";
    public static final String DISABLE_TRANSPORTS = "disabletransports";
    private Client cl;

    Config(Client cl) {
        this.cl = cl;
    }

    public synchronized void setOption(String option, String value) throws GeneralClientException {
        this.cl.execute("setvar " + option + " " + value);
    }

    public synchronized String getOption(String option) throws GeneralClientException {
        return this.cl.evaluate("cfg_" + option);
    }

    public synchronized void save() throws GeneralClientException {
        this.cl.execute("config save");
    }

    public synchronized void load() throws GeneralClientException {
        this.cl.execute("config load");
    }

    public synchronized Map getDump() throws GeneralClientException, InterruptedException {
        final TreeMap cachedConfig = new TreeMap();
        final Semaphore s = new Semaphore();
        EventListenerManager manager = Server.getInstance().getEventListenersManager();
        MessageEventListener mel = new MessageEventListener(){

            public void messageReceived(String msg) {
                if (msg.startsWith(">")) {
                    if ((msg = msg.substring(1)).equalsIgnoreCase(Config.DUMP_END)) {
                        s.release();
                    } else {
                        int key_end = msg.indexOf(58);
                        if (key_end == -1) {
                            return;
                        }
                        int value_start = msg.indexOf(58, key_end + 1);
                        if (value_start == -1) {
                            return;
                        }
                        String key = msg.substring(0, key_end);
                        String val = msg.substring(value_start + 2, msg.length() - 1);
                        cachedConfig.put(key, val);
                    }
                }
            }
        };
        Config config = this.cl.getConfig();
        String oldoutput = config.getOption(OUTPUT_COMMAND);
        String oldtransports = config.getOption(DISABLE_TRANSPORTS);
        config.setOption(OUTPUT_COMMAND, "");
        config.setOption(DISABLE_TRANSPORTS, "1");
        manager.addMessageEventListener(mel);
        this.cl.execute("cfgdump");
        s.acquire();
        config.setOption(OUTPUT_COMMAND, oldoutput == null ? "" : oldoutput);
        config.setOption(DISABLE_TRANSPORTS, oldtransports);
        manager.removeMessageEventListener(mel);
        return cachedConfig;
    }
}

