/*
 * Decompiled with CFR 0.152.
 */
package amip.api.examples.highlevel;

import amip.api.examples.util.Helpers;
import amip.api.highlevel.Client;
import amip.api.highlevel.EventListenerManager;
import amip.api.highlevel.Server;
import amip.api.highlevel.exceptions.ClientInitializationFailedException;
import amip.api.highlevel.exceptions.GeneralClientException;
import amip.api.highlevel.exceptions.ServerStartupFailedException;
import amip.api.highlevel.listeners.AEventListener;
import amip.api.highlevel.listeners.TimerEventListener;

public class VariableWatcher {
    public static void main(String[] args) throws ServerStartupFailedException, ClientInitializationFailedException, GeneralClientException {
        if (args.length == 0) {
            System.out.println("You must specify AMIP variable to watch");
            return;
        }
        final String var = args[0];
        System.out.println("Watching for changes of: " + var);
        final Client c = Client.getInstance();
        Server s = Server.getInstance();
        c.init();
        s.start();
        EventListenerManager manager = s.getEventListenersManager();
        manager.addEventListener((AEventListener)new TimerEventListener(){
            String value = "";

            public void eventReceived() {
                try {
                    String newval = c.evaluate(var);
                    if (newval == null) {
                        return;
                    }
                    if (newval.compareToIgnoreCase(this.value) != 0) {
                        this.value = newval;
                        System.out.println(var + " = " + newval);
                    }
                }
                catch (GeneralClientException e) {
                    e.printStackTrace();
                }
            }
        });
        Helpers.setupTerminationHandlerAndWait(Thread.currentThread());
        manager.removeAllEventListeners();
        c.uninit();
        s.stop();
    }
}

