/*
 * Decompiled with CFR 0.152.
 */
package amip.api.wrapper;

import amip.api.wrapper.callbacks.EventCallback;
import amip.api.wrapper.callbacks.MessageCallback;

public class AMIPAPI {
    public static final boolean isAMD64 = "amd64".equals(System.getProperty("os.arch"));
    public static MessageCallback msgCallback;
    public static EventCallback evtCallback;

    public static boolean loadNativeLibs() {
        try {
            if (isAMD64) {
                System.loadLibrary("ac64");
                System.loadLibrary("ac_java64");
            } else {
                System.loadLibrary("ac");
                System.loadLibrary("ac_java");
            }
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
        catch (SecurityException e1) {
            return false;
        }
        return true;
    }

    public static void setMsgCallback(MessageCallback msgCallback) {
        AMIPAPI.msgCallback = msgCallback;
        AMIPAPI.register_msg_callback();
    }

    public static void setEvtCallback(EventCallback evtCallback) {
        AMIPAPI.evtCallback = evtCallback;
        AMIPAPI.register_evt_callback();
    }

    public static native int init_client(String var0, int var1, int var2, int var3, int var4);

    public static native int init_server(String var0, int var1);

    public static native void init(int var0);

    public static native void uninit();

    public static native void uninit_client();

    public static native void stop_server();

    public static native int exec(String var0);

    public static native String eval(String var0);

    public static native String format(String var0);

    private static native void register_msg_callback();

    private static native void register_evt_callback();

    public static void message_callback(String msg) {
        if (msgCallback != null) {
            msgCallback.process(msg);
        }
    }

    public static void event_callback(int code) {
        if (evtCallback != null) {
            evtCallback.process(code);
        }
    }

    public static native int add_event_listener(String var0, int var1, int var2, int var3, int var4);

    public static native int remove_event_listener(String var0, int var1);

    public static native boolean pingServer(String var0, int var1, int var2);

    public static native int get_pl();

    public static native int get_plsize();

    public static native String get_title(int var0);

    public static native void setDestPort(int var0);

    public static native void setDestHost(String var0);

    public static native void setTimeout(int var0);

    public static native void setSrcPort(int var0);

    public static native void setSrcHost(String var0);

    public static native void rehash();

    public static native int get_last_error();

    public static native int ac_version_major();

    public static native int ac_version_minor();

    public static native int ac_is_server_started();

    public static native int ac_is_client_initialized();

    public static int version_major() {
        return AMIPAPI.ac_version_major();
    }

    public static int version_mainor() {
        return AMIPAPI.ac_version_minor();
    }

    public static int is_server_started() {
        return AMIPAPI.ac_is_server_started();
    }

    public static int is_client_initialized() {
        return AMIPAPI.ac_is_client_initialized();
    }

    public static native String get_file_version(String var0);

    static {
        AMIPAPI.loadNativeLibs();
    }
}

