/*
 * Decompiled with CFR 0.152.
 */
package amip.api.highlevel;

import amip.api.highlevel.Client;
import amip.api.highlevel.EventListenerManager;
import amip.api.highlevel.Server;
import amip.api.highlevel.exceptions.GeneralClientException;
import amip.api.highlevel.listeners.PlaylistChangeEventListener;
import amip.api.highlevel.listeners.PlaylistReadyEventListener;
import amip.api.highlevel.listeners.SyncCompleteEventListener;
import amip.api.highlevel.util.Semaphore;
import amip.api.highlevel.util.Utils;
import amip.api.wrapper.AMIPAPI;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;

public class Playlist {
    private final Object sync = new Object();
    private EventListenerList listenerList = new EventListenerList();
    private ArrayList plist;
    private boolean autoSynchronize = false;
    private boolean shouldProcessReadyEvent = false;
    private PlaylistChangeEventListener ourChangeListener;
    private PlaylistReadyEventListener ourReadyListener;

    Playlist() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSyncCompleteListener(SyncCompleteEventListener l) {
        Object object = this.sync;
        synchronized (object) {
            this.listenerList.add(SyncCompleteEventListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSyncCompleteListener(SyncCompleteEventListener l) {
        Object object = this.sync;
        synchronized (object) {
            this.listenerList.remove(SyncCompleteEventListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSyncComplete() {
        Object object = this.sync;
        synchronized (object) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                ((SyncCompleteEventListener)listeners[i + 1]).syncComplete();
            }
        }
    }

    public boolean isAutoSynchronize() {
        return this.autoSynchronize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.sync;
        synchronized (object) {
            return this.plist == null ? 0 : this.plist.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTitle(int index) {
        Object object = this.sync;
        synchronized (object) {
            return this.getSize() >= index + 1 ? null : this.plist.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getCopy() {
        Object object = this.sync;
        synchronized (object) {
            return (ArrayList)(this.plist == null ? new ArrayList() : this.plist.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList syncAndGetCopy() throws GeneralClientException, InterruptedException {
        final Semaphore s = new Semaphore();
        SyncCompleteEventListener scl = new SyncCompleteEventListener(){

            public void syncComplete() {
                s.release();
            }
        };
        this.addSyncCompleteListener(scl);
        this.sync();
        s.acquire();
        this.removeSyncCompleteListener(scl);
        Object object = this.sync;
        synchronized (object) {
            return this.getCopy();
        }
    }

    public boolean isInSync() {
        return "1".equals(AMIPAPI.eval("var_listinsync"));
    }

    public void setAutoSynchronize(boolean autoSynchronize) throws GeneralClientException {
        EventListenerManager elm = Server.getInstance().getEventListenersManager();
        if (!this.autoSynchronize && autoSynchronize) {
            this.ourChangeListener = new PlaylistChangeEventListener(){

                public void eventReceived() {
                    try {
                        Playlist.this.sync();
                    }
                    catch (GeneralClientException generalClientException) {
                        // empty catch block
                    }
                }
            };
        } else if (this.autoSynchronize && !autoSynchronize) {
            elm.removeEventListener(this.ourChangeListener);
        }
        if (autoSynchronize && this.ourChangeListener != null) {
            elm.removeEventListener(this.ourChangeListener);
            elm.addEventListener(this.ourChangeListener);
        }
        this.autoSynchronize = autoSynchronize;
    }

    public void sync() throws GeneralClientException {
        this.shouldProcessReadyEvent = true;
        EventListenerManager elm = Server.getInstance().getEventListenersManager();
        if (this.ourReadyListener == null) {
            this.ourReadyListener = new PlaylistReadyEventListener(){

                public void eventReceived() {
                    if (Playlist.this.shouldProcessReadyEvent) {
                        Playlist.this.shouldProcessReadyEvent = false;
                        Playlist.this.processReadyEvent();
                    }
                }
            };
        }
        elm.removeEventListener(this.ourReadyListener);
        elm.addEventListener(this.ourReadyListener);
        if (!this.isInSync()) {
            Client.getInstance().execute("reindexq");
        } else {
            this.processReadyEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReadyEvent() {
        Object object = this.sync;
        synchronized (object) {
            try {
                int res = AMIPAPI.get_pl();
                Utils.errorToException(res);
            }
            catch (GeneralClientException e) {
                // empty catch block
            }
            if (this.plist != null) {
                this.plist.clear();
            }
            int plsize = AMIPAPI.get_plsize();
            if (this.plist == null) {
                this.plist = new ArrayList(plsize);
            } else {
                this.plist.ensureCapacity(plsize);
            }
            for (int i = 0; i < plsize; ++i) {
                this.plist.add(i, AMIPAPI.get_title(i));
            }
            this.fireSyncComplete();
        }
    }
}

