/*
 * Decompiled with CFR 0.152.
 */
package amip.api.highlevel;

import amip.api.highlevel.Client;
import amip.api.highlevel.exceptions.GeneralClientException;

public class Player {
    private Client cl;
    public static final int STATUS_PLAYING = 1;
    public static final int STATUS_PAUSED = 3;
    public static final int STATUS_STOPPED = 0;

    Player() {
    }

    Player(Client cl) {
        this.cl = cl;
    }

    public void play() throws GeneralClientException {
        this.cl.execute("control play");
    }

    public void play(int i) throws GeneralClientException {
        this.cl.execute("play " + ++i);
    }

    public void pause() throws GeneralClientException {
        this.cl.execute("control pause");
    }

    public void stop() throws GeneralClientException {
        this.cl.execute("control stop");
    }

    public void next() throws GeneralClientException {
        this.cl.execute("control >");
    }

    public void previous() throws GeneralClientException {
        this.cl.execute("control <");
    }

    public void setVolume(int volume) throws GeneralClientException {
        this.cl.execute("control vol " + volume);
    }

    public void volumeUp() throws GeneralClientException {
        this.cl.execute("control vup");
    }

    public void volumeDown() throws GeneralClientException {
        this.cl.execute("control vdwn");
    }

    public void fastForward() throws GeneralClientException {
        this.cl.execute("control ff");
    }

    public void rewind() throws GeneralClientException {
        this.cl.execute("control rew");
    }

    public void jump(int time) throws GeneralClientException {
        this.cl.execute("jumptotime " + time);
    }

    public void minimizeWindow() throws GeneralClientException {
        this.cl.execute("control mimimize");
    }

    public void restoreWindow() throws GeneralClientException {
        this.cl.execute("control restore");
    }

    public void setShuffle(boolean shuffle) throws GeneralClientException {
        this.cl.execute("setshuffle " + (shuffle ? "on" : "off"));
    }

    public boolean isShuffle() throws GeneralClientException {
        return "on".equalsIgnoreCase(this.cl.evaluate("var_shuffle"));
    }

    public void setRepeat(boolean repeat) throws GeneralClientException {
        this.cl.execute("setrepeat " + (repeat ? "on" : "off"));
    }

    public boolean isRepeat() throws GeneralClientException {
        return "on".equalsIgnoreCase(this.cl.evaluate("var_repeat"));
    }

    public void showAMIPOptions() throws GeneralClientException {
        this.cl.execute("options");
    }

    public void showAMIPSearch() throws GeneralClientException {
        this.cl.execute("search");
    }

    public void showAMIPHelp() throws GeneralClientException {
        this.cl.execute("help");
    }

    public int getListPosition() throws GeneralClientException {
        int res = -1;
        try {
            res = Integer.parseInt(this.cl.evaluate("var_pos"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (res != -1) {
            --res;
        }
        return res;
    }

    public int getSongLength() throws GeneralClientException {
        int res = -1;
        try {
            res = Integer.parseInt(this.cl.evaluate("var_sl"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return res;
    }

    public String getVersion() throws GeneralClientException {
        return this.cl.evaluate("var_ver");
    }

    public String getName() throws GeneralClientException {
        return this.cl.evaluate("var_player");
    }

    public String getAMIPVersion() throws GeneralClientException {
        return this.cl.evaluate("var_pv");
    }

    public int getStatus() throws GeneralClientException {
        int res = 0;
        try {
            res = Integer.parseInt(this.cl.evaluate("var_stat"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return res;
    }
}

