/*
 * Decompiled with CFR 0.152.
 */
package amip.api.highlevel;

import amip.api.highlevel.Config;
import amip.api.highlevel.Player;
import amip.api.highlevel.Playlist;
import amip.api.highlevel.exceptions.ClientInitializationFailedException;
import amip.api.highlevel.exceptions.GeneralClientException;
import amip.api.highlevel.util.Utils;
import amip.api.wrapper.AMIPAPI;

public class Client {
    private static Client ourInstance;
    private Playlist plist;
    private Player player;
    private Config config;
    private String host = "127.0.0.1";
    private int port = 60333;
    private int timeout = 5000;
    private int dsec = 5;
    private int dcount = 1;
    private boolean initialized = false;

    private Client() {
    }

    private static synchronized void createInstance() {
        if (ourInstance == null) {
            ourInstance = new Client();
        }
    }

    public static synchronized Client getInstance() {
        if (ourInstance == null) {
            Client.createInstance();
        }
        return ourInstance;
    }

    public void init(String host, int port, int timeout, int dsec, int dcount) throws ClientInitializationFailedException {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.dsec = dsec;
        this.dcount = dcount;
        this.init();
    }

    public void init(String host, int port) throws ClientInitializationFailedException {
        this.host = host;
        this.port = port;
        this.init();
    }

    public void init() throws ClientInitializationFailedException {
        int res = AMIPAPI.init_client(this.host, this.port, this.timeout, this.dsec, this.dcount);
        if (res == 0) {
            throw new ClientInitializationFailedException();
        }
        this.initialized = true;
    }

    public void uninit() {
        if (this.initialized) {
            AMIPAPI.uninit_client();
        }
        this.initialized = false;
    }

    public String evaluate(String variable) throws GeneralClientException {
        String res = AMIPAPI.eval(variable);
        Utils.errorToException(AMIPAPI.get_last_error());
        return res;
    }

    public void execute(String command) throws GeneralClientException {
        int res = AMIPAPI.exec(command);
        Utils.errorToException(res);
    }

    public String format(String spec) throws GeneralClientException {
        String res = AMIPAPI.format(spec);
        Utils.errorToException(AMIPAPI.get_last_error());
        return res;
    }

    public String format(int preset) throws GeneralClientException {
        String res = AMIPAPI.eval("formatpreset " + preset);
        Utils.errorToException(AMIPAPI.get_last_error());
        return res;
    }

    public boolean pingServer() {
        return AMIPAPI.pingServer(this.host, this.port, this.timeout);
    }

    public int getDcount() {
        return this.dcount;
    }

    public void setDcount(int dcount) {
        this.dcount = dcount;
    }

    public int getDsec() {
        return this.dsec;
    }

    public void setDsec(int dsec) {
        this.dsec = dsec;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Playlist getPlaylist() {
        if (this.plist == null) {
            this.plist = new Playlist();
        }
        return this.plist;
    }

    public Player getPlayer() {
        if (this.player == null) {
            this.player = new Player(this);
        }
        return this.player;
    }

    public Config getConfig() {
        if (this.config == null) {
            this.config = new Config(this);
        }
        return this.config;
    }
}

