/*
 * Decompiled with CFR 0.152.
 */
package amip.api.examples.highlevel;

import amip.api.examples.util.Helpers;
import amip.api.highlevel.Client;
import amip.api.highlevel.EventListenerManager;
import amip.api.highlevel.Player;
import amip.api.highlevel.Server;
import amip.api.highlevel.exceptions.GeneralClientException;
import amip.api.highlevel.listeners.AEventListener;
import amip.api.highlevel.listeners.ChangeEventListener;
import amip.api.highlevel.listeners.MessageEventListener;
import amip.api.highlevel.listeners.StartEventListener;
import amip.api.wrapper.AMIPAPI;

public class StressTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (!AMIPAPI.loadNativeLibs()) {
            System.err.println("Can't load the native libraries");
            return;
        }
        final Client c = Client.getInstance();
        Server s = Server.getInstance();
        s.setPort(Server.findFreeLocalPort());
        try {
            c.init();
            s.start();
            EventListenerManager elm = s.getEventListenersManager();
            elm.addEventListener((AEventListener)new StartEventListener(){

                public void eventReceived() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    boolean ping = c.pingServer();
                    StressTest.printStatus(c);
                    System.out.println("ping = " + ping);
                    try {
                        Player player = c.getPlayer();
                        int status = player.getStatus();
                        System.out.println("int status = " + status);
                        if (status == 3) {
                            player.pause();
                        } else if (status == 0) {
                            player.play();
                        }
                    }
                    catch (GeneralClientException e) {
                        e.printStackTrace();
                    }
                }
            });
            elm.addEventListener((AEventListener)new ChangeEventListener(){

                public void eventReceived() {
                    StressTest.printStatus(c);
                }
            });
            elm.addMessageEventListener(new MessageEventListener(){

                public void messageReceived(String msg) {
                    System.out.println("msg = " + msg);
                }
            });
            Helpers.setupTerminationHandlerAndWait(Thread.currentThread());
            s.getEventListenersManager().removeAllEventListeners();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            c.uninit();
            s.stop();
        }
    }

    private static void printStatus(Client c) {
        String status = null;
        try {
            status = c.format("%tstat");
        }
        catch (GeneralClientException e) {
            e.printStackTrace();
        }
        System.out.println("status = " + status);
    }
}

