/*
 * Decompiled with CFR 0.152.
 */
package amip.api.examples.highlevel;

import amip.api.examples.util.Helpers;
import amip.api.highlevel.Client;
import amip.api.highlevel.EventListenerManager;
import amip.api.highlevel.Server;
import amip.api.highlevel.listeners.AEventListener;
import amip.api.highlevel.listeners.ExitEventListener;
import amip.api.highlevel.listeners.MessageEventListener;
import amip.api.highlevel.listeners.PauseEventListener;
import amip.api.highlevel.listeners.PlayEventListener;

public class EventWatcher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Client c = Client.getInstance();
        Server s = Server.getInstance();
        try {
            c.init();
            s.start();
            EventListenerManager elm = s.getEventListenersManager();
            elm.addEventListener((AEventListener)new ExitEventListener(){

                public void eventReceived() {
                    System.out.println("Player exiting");
                }
            });
            elm.addEventListener((AEventListener)new PauseEventListener(){

                public void eventReceived() {
                    System.out.println("Player paused");
                }
            });
            elm.addEventListener((AEventListener)new PlayEventListener(){

                public void eventReceived() {
                    System.out.println("Player unpaused");
                }
            });
            elm.addMessageEventListener(new MessageEventListener(){

                public void messageReceived(String msg) {
                    System.out.println("Message received: " + msg);
                }
            });
            System.out.println("Listening for events... Press Ctrl+C to exit...");
            Helpers.setupTerminationHandlerAndWait(Thread.currentThread());
            elm.removeAllEventListeners();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            s.stop();
            c.uninit();
        }
    }
}

