using System;

namespace DJMatty.AMIP.ClientWrapper
{
  internal class AMIPServer : IDisposable
  {
    #region Private Members
    private string _host = "";
    private int _port = 0;
    private string _key = "";

    private bool _addedEventListener = false;

    private bool _isDisposed = false;

    #endregion

    #region Public Properties
    public string Host
    {
      get
      {
        return _host;
      }
    }

    public int Port
    {
      get
      {
        return _port;
      }
    }

    public string Key
    {
      get
      {
        return _key;
      }
    }
    #endregion

    #region Constructors
    public AMIPServer(string host, int port)
    {
      _host = host;
      _port = port;

      _key = BuildKey(host, port);
    }
    #endregion

    #region Public Methods

    public void AddEventListener(int timeout, Constants.EventFlags events, uint failureCount)
    {
      if (!_addedEventListener)
      {
        Constants.ErrorCode err = AMIPAPI.AddEvtListener(_host, _port, timeout, (uint) events, failureCount);
        if (err != Constants.ErrorCode.AC_ERR_NOERROR)
        {
          throw new AMIPAPIException(err);
        }
        _addedEventListener = true;
      }
      else
      {
        throw new AMIPException(String.Format("Already added listener for server: {0}", _key));
      }
    }

    public static string BuildKey(string host, int port)
    {
      return String.Format("{0}:{1}", host, port);
    }

    #endregion

    #region Dispose
    public virtual void Dispose(bool disposing)
    {
      if (!_isDisposed)
      {
        if (disposing)
        {
          if (_addedEventListener)
          {
            AMIPAPI.RemoveEvtListener(_host, _port);
          }
        }
      }
      _isDisposed = true;
    }

    public void Dispose()
    {
      Dispose(true);
      GC.SuppressFinalize(this);
    }

    ~AMIPServer()
    {
      Dispose(false);
    }
    #endregion
  }
}
