using System;

namespace DJMatty.AMIP.ClientWrapper
{
  /// <summary>
  /// AMIPAPIException is thrown when an AMIP API call returns an error
  /// </summary>
  public class AMIPAPIException : AMIPException
  {
    /// <summary>
    /// Default Constructor
    /// </summary>
    public AMIPAPIException()
      : base()
    {

    }

    /// <summary>
    /// Constructor
    /// </summary>
    /// <param name="message">Exception detail text</param>
    public AMIPAPIException(string message)
      : base(message)
    {

    }

    /// <summary>
    /// Constructor
    /// </summary>
    /// <param name="message">Exception detail text</param>
    /// <param name="innerException">Any inner exception</param>
    public AMIPAPIException(string message, Exception innerException)
      : base(message, innerException)
    {

    }

    /// <summary>
    /// Constructor
    /// </summary>
    /// <param name="ec">Error code, stored in Message property</param>
    public AMIPAPIException(Constants.ErrorCode ec)
      : base(ec.ToString())
    {
    }

    /// <summary>
    /// Constructor
    /// </summary>
    /// <param name="ec">Error code, stored in Message property</param>
    /// <param name="innerException">Any inner exception</param>
    public AMIPAPIException(Constants.ErrorCode ec, Exception innerException)
      : base(ec.ToString(), innerException)
    {
    }
  }
}
