using System;

namespace DJMatty.AMIP.ClientWrapper
{
  /// <summary>
  /// Class to store constants used within the AMIP Wrapper
  /// </summary>
  public class Constants
  {
    /// <summary>
    /// StartMode is not currently used by the AMIP wrapper
    /// </summary>
    public enum StartMode
    {
      /// <summary>
      /// Start client and server
      /// </summary>
      AC_START_ALL = 0,
      /// <summary>
      /// Start only the client
      /// </summary>
      AC_START_CLIENT,
      /// <summary>
      /// Start only the server
      /// </summary>
      AC_START_SERVER,
      /// <summary>
      /// Start nothing
      /// </summary>
      AC_START_NONE
    }

    /// <summary>
    /// Error codes returned from AMIP API calls
    /// </summary>
    public enum ErrorCode
    {
      /// <summary>
      /// No error
      /// </summary>
      AC_ERR_NOERROR = 0,
      /// <summary>
      /// AMIP client is null
      /// </summary>
      AC_ERR_CLIENTISNULL,
      /// <summary>
      /// Exception occurred
      /// </summary>
      AC_ERR_EXCEPTION,
      /// <summary>
      /// TCP connection failed
      /// </summary>
      AC_ERR_CONNECTIONFAILED,
      /// <summary>
      /// AMIP Server not running
      /// </summary>
      AC_ERR_SERVERNOTRUNNING
    }

    /// <summary>
    /// EventFlags can be used to adjust what the server listens for and also what events have fired
    /// Bitwise OR them
    /// </summary>
    [Flags]
    public enum EventFlags
    {
      /// <summary>
      /// Play event
      /// </summary>
      Play = 0x01,
      /// <summary>
      /// Pause event
      /// </summary>
      Pause = 0x02,
      /// <summary>
      /// Stop event
      /// </summary>
      Stop = 0x04,
      /// <summary>
      /// Start event
      /// </summary>
      Start = 0x08,
      /// <summary>
      /// WinAmp\AMIP exited
      /// </summary>
      Exit = 0x10,
      /// <summary>
      /// Timer Event
      /// </summary>
      Timer = 0x20,
      /// <summary>
      /// Msg event
      /// </summary>
      Msg = 0x40,
      /// <summary>
      /// Track changed event
      /// </summary>
      Change = 0x80,
      /// <summary>
      /// Playlist changed event
      /// </summary>
      PlaylistChange = 0x100,
      /// <summary>
      /// Playlist ready event
      /// </summary>
      PlaylistReady = 0x200,
      /// <summary>
      /// All events - Play | Pause | Stop | Start | Exit | Change | PlaylistChange | PlaylistReady
      /// </summary>
      All = Play | Pause | Stop | Start | Exit | Change | PlaylistChange | PlaylistReady
    }

    internal const int AC_BUFFER_SIZE = 2048;
      
    internal delegate void AC_MSG_CALLBACK(string msg);
    internal delegate void AC_EVT_CALLBACK(int evt);

  }
}
