using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace DJMatty.AMIP.ClientWrapper
{
  internal class AMIPAPI
  {
    [DllImport("ac.dll", EntryPoint = "ac_init_client")]
    static extern public int InitClient(string host, int port, int timeout, int dsec, int dcount);

    [DllImport("ac.dll", EntryPoint = "ac_init_server")]
    static extern public int InitServer(string host, int port);

    [DllImport("ac.dll", EntryPoint = "ac_init")]
    static extern public void Init(Constants.StartMode mode);

    [DllImport("ac.dll", EntryPoint = "ac_uninit")]
    static extern public void UnInit();

    [DllImport("ac.dll", EntryPoint = "ac_uninit_client")]
    static extern public void UnInitClient();

    [DllImport("ac.dll", EntryPoint = "ac_stop_server")]
    static extern public void StopServer();

    [DllImport("ac.dll", EntryPoint = "ac_exec")]
    static extern public Constants.ErrorCode Exec(string cmd);

    [DllImport("ac.dll", EntryPoint = "ac_eval")]
    static extern public Constants.ErrorCode Eval(string cmd, StringBuilder result);

    [DllImport("ac.dll", EntryPoint = "ac_format")]
    static extern public Constants.ErrorCode Format(string cmd, StringBuilder result);

    [DllImport("ac.dll", EntryPoint = "ac_register_msg_callback")]
    static extern public void RegisterMsgCallback(Constants.AC_MSG_CALLBACK callback);

    [DllImport("ac.dll", EntryPoint = "ac_register_evt_callback")]
    static extern public void RegisterEvtCallback(Constants.AC_EVT_CALLBACK callback);

    [DllImport("ac.dll", EntryPoint = "ac_add_event_listener")]
    static extern public Constants.ErrorCode AddEvtListener(string host, int port, int timeout, uint flags, uint fail_count);

    [DllImport("ac.dll", EntryPoint = "ac_remove_event_listener")]
    static extern public Constants.ErrorCode RemoveEvtListener(string host, int port);

    [DllImport("ac.dll", EntryPoint = "ac_pingServer")]
    static extern public bool PingServer(string host, int port, int timeout);

    [DllImport("ac.dll", EntryPoint = "ac_get_pl")]
    static extern public Constants.ErrorCode GetPlaylist();

    [DllImport("ac.dll", EntryPoint = "ac_get_plsize")]
    static extern public int GetPlaylistSize();

    [DllImport("ac.dll", EntryPoint = "ac_get_title")]
    static extern public int GetTitle(uint index, StringBuilder buffer);

    [DllImport("ac.dll", EntryPoint = "ac_setDestPort")]
    static extern public void SetDestinationPort(int port);

    [DllImport("ac.dll", EntryPoint = "ac_setDestHost")]
    static extern public void SetDestinationHost(string host);

    [DllImport("ac.dll", EntryPoint = "ac_setTimeout")]
    static extern public void SetTimeout(int ms);

    [DllImport("ac.dll", EntryPoint = "ac_setSrcPort")]
    static extern public void SetSourcePort(int port);

    [DllImport("ac.dll", EntryPoint = "ac_setSrcHost")]
    static extern public void SetSourceHost(string host);
    
    [DllImport("ac.dll", EntryPoint = "ac_getSrcPort")]
    static extern public int GetSourcePort();

    [DllImport("ac.dll", EntryPoint = "ac_getDestPort")]
    static extern public int GetDestinationPort();

    [DllImport("ac.dll", EntryPoint = "ac_getSrcHost")]
    static extern public void GetSourceHost(StringBuilder host);

    [DllImport("ac.dll", EntryPoint = "ac_getDestHost")]
    static extern public void GetDestinationHost(StringBuilder host);

    [DllImport("ac.dll", EntryPoint = "ac_rehash")]
    static extern public void Rehash();

    [DllImport("ac.dll", EntryPoint = "ac_version_major")]
    static extern public int GetMajorVersion();

    [DllImport("ac.dll", EntryPoint = "ac_version_minor")]
    static extern public int GetMinorVersion();
    
  }
}
