/*
 This sample illustrates how to get song details formatted according to the provided
 format specification.
 
 This tool can be used remotely with AMIP running on another host.
 
 Usage: getsonginfo.exe [-q] [-h host] [-p port] format
   -q       is for quiet operation, no error messages will be printed
   -h host  specifies host name/address where AMIP is running (default 127.0.0.1)
   -p port  port number where AMIP is running (default 60333)
   format   is the string with AMIP variables, quotes should be escaped.

 Sample usage: getsonginfo.exe -q -h 127.0.0.1 -p 60333 np: %name
 Result:       np: Linkin Park - Shadow Of The Day
 */

#include <windows.h>
#include <stdio.h>
#include <string>

#include "../ac.h"
#include "xgetopt.h"

std::string host = "127.0.0.1";
std::string format = "np: %name %?4<\"%4\"|>";
int port = 60333;
BOOL quiet= FALSE;

BOOL process_cmd_line(int argc, TCHAR *argv[]) {
  int c;

  while ((c = getopt(argc, argv, "qh:p:")) != EOF) {
    switch (c) {
      case 'q':
        quiet = TRUE;
        break;
      case 'h':
        host = optarg;
        break;
      case 'p':
        port = atoi(optarg);
        break;
      default:
        if (!quiet)
          printf("WARNING: no handler for option %c\n", c);
        return FALSE;
        break;
    }
  }

  std::string strArgs = "";
  if (optind < argc) {
    while (optind < argc) {
      strArgs.append(argv[optind]);
      if (optind < argc - 1) strArgs.append(" ");
      optind++;
    }
  }

  if (strArgs.length() > 0) {
    format = strArgs;
  }

  return TRUE;
}

int main(int argc, char **argv) {
  if (!process_cmd_line(argc, argv)) {
    if (!quiet)
      printf("Incorrect options");
    exit(1);
  }

  ac_init_client(host.c_str(), port, 1000, 5, 1);

  char np[AC_BUFFER_SIZE];

  if (AC_ERR_NOERROR == ac_format(format.c_str(), np)) {
    printf("%s", np);
  } else {
    if (!quiet)
      printf("Error connecting to AMIP Server\n");
  }

  ac_uninit();
  return 0;
}
