/*
Executes API commands from the command line, if no command is 
specified shows current now playing track.

Sample usage:

cmdclient.exe control pause  -- to pause playback
cmdclient.exe control >      -- next track

See http://amip.tools-for.net/wiki/manual/amip#api_commands
for the complete list of API commands.
*/

#include <windows.h>
#include <string>
#include <stdio.h>
#include "../ac.h"

int main(int argc, char **argv)
{
  std::string cmd;
  
  for(int i=1; i < argc; i++){
    cmd.append(argv[i]);
    cmd.append(" ");
  }

  ac_init_client("127.0.0.1", 60333, 1000, 5, 1);

  if (argc > 1) {
    int ires = ac_exec(cmd.c_str());
    if (ires == AC_ERR_NOERROR)
      printf("OK: %s", cmd.c_str());
    else
      printf("FAILED with code: %d", ires);
  } else {
    char np[2048];
    if (AC_ERR_NOERROR == ac_eval("var_name", np)) {
      printf("Now playing: %s\n", np);
    } else {
      printf("Error connecting to AMIP Server\n");
    }
  }

  ac_uninit();
  return 0;
}
