unit Unit1;

{------------------------------------------------------------------------------}
{               *** Delphi7 sample of the AMIP public API ***                  }
{                                                                              }
{ version: 1.0                                                                 }
{                                                                              }
{ by: blert ( blert at blertdiscorporated dot com )                            }
{ last update: January 31, 2006                                                }
{                                                                              }
{ -Your AMIP enabled player must be running before launching this sample app!  }
{  If not, the buttons will be disabled so as to not cause a crash.            }
{ -It also assumes address and port for server and client to be as follows:    }
{  server: 127.0.0.1:60334                                                     }
{  client: 127.0.0.1:60333                                                     }
{------------------------------------------------------------------------------}

interface

uses
  Windows, SysUtils, Forms, Classes,
  Controls, StdCtrls, ComCtrls, Buttons,
  AMIPWrapper;

type
  TForm1 = class(TForm)
    AMIPWrapper1: TAMIPWrapper;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Memo1: TMemo;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    StatusBar1: TStatusBar;
    procedure CommandButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    critSec: TRTLCriticalSection;
    procedure ClearNowPlaying;
    procedure GetNowPlaying;
    procedure GetPlaylist;
    procedure GetVersion;
    procedure ReindexPlaylist;
    procedure ShowPause;
  public
    //
  end;

procedure EventCallback(aInt: integer); stdcall;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure EventCallback(aInt: integer); stdcall;
begin
  case aInt of
    AC_EVT_PLAY: Form1.GetNowPlaying;
    AC_EVT_PAUSE: Form1.ShowPause;
    AC_EVT_STOP: Form1.ClearNowPlaying;
    AC_EVT_START: Form1.ClearNowPlaying;
    AC_EVT_EXIT: Form1.ClearNowPlaying;
    AC_EVT_CHANGE: Form1.GetNowPlaying;
    AC_EVT_PLCHANGE: Form1.ReindexPlaylist;
    AC_EVT_PLREADY: Form1.GetPlaylist;
  end;
end;

{------------------------------------------------------------------------------}

procedure TForm1.ClearNowPlaying;
begin
  Label2.Caption := 'Nothing';
end;

procedure TForm1.GetNowPlaying;
var
  res: array[0..AC_BUFFER_SIZE] of char;
begin
  if TryEnterCriticalSection(critSec) then
    begin
      AMIPWrapper1.ac_eval('var_name', res);
      LeaveCriticalSection(critSec);
    end;
  Label2.Caption := res;
end;

procedure TForm1.GetPlaylist;
var
  plCount, i: integer;
  plBuff: array[0..AC_BUFFER_SIZE] of char;
begin
  if TryEnterCriticalSection(critSec) then
    begin
      AMIPWrapper1.ac_get_pl;
      plCount := AMIPWrapper1.ac_get_plsize;
      Memo1.Clear;
      for i := 0 to plCount do
        begin
          FillChar(plBuff, (AC_BUFFER_SIZE + 1) * SizeOf(char), Ord(' '));
          if AMIPWrapper1.ac_get_title(i, plBuff) = 1 then Memo1.Lines.Add(Trim(plBuff));
        end;
      LeaveCriticalSection(critSec);
    end;
end;

procedure TForm1.GetVersion;
var
  s: string;
begin
  if TryEnterCriticalSection(critSec) then
    begin
      s := IntToStr(AMIPWrapper1.ac_version_major) + '.' + IntToStr(AMIPWrapper1.ac_version_minor);
      LeaveCriticalSection(critSec);
    end;
  Label3.Caption := 'AMIP API version: ' + s;
end;

procedure TForm1.ReindexPlaylist;
begin
  if TryEnterCriticalSection(critSec) then
    begin
      AMIPWrapper1.ac_exec('reindexq');
      LeaveCriticalSection(critSec);
    end;
end;

procedure TForm1.ShowPause;
begin
  Label2.Caption := Label2.Caption + ' ***PAUSED***';
end;

{------------------------------------------------------------------------------}

procedure TForm1.CommandButtonClick(Sender: TObject);
begin
  case (Sender as TSpeedButton).Tag of
    0: AMIPWrapper1.ac_exec('control stop');
    1: AMIPWrapper1.ac_exec('control pause');
    2: AMIPWrapper1.ac_exec('control play');
    3: AMIPWrapper1.ac_exec('control rew');
    4: AMIPWrapper1.ac_exec('control <');
    5: AMIPWrapper1.ac_exec('control >');
    6: AMIPWrapper1.ac_exec('control ff');
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  sBuff: string;
begin
  sBuff := 'OK';
  try
    // load dll
    if AMIPWrapper1.LoadDLL > ERR_DLL_ALREADYLOADED then
      begin
        sBuff := 'DLL not found -or- DLL load failure!';
        Exit;
      end;
    // start server
    if AMIPWrapper1.ac_init_server('127.0.0.1', 60334) <> 1 then
      begin
        sBuff := 'Server could not be started!';
        Exit;
      end;
    //start client
    if AMIPWrapper1.ac_init_client('127.0.0.1', 60333, 1000, 5, 1) <> 1 then
      begin
        sBuff := 'Client could not be started!';
        Exit;
      end;
    //add event listener
    if AMIPWrapper1.ac_add_event_listener('127.0.0.1', 60334, 1000, AC_EVT_ALL, 1) <> AC_ERR_NOERROR then
      begin
        sBuff := 'Listener could not be added!';
        Exit;
      end;
    //register event callback
    AMIPWrapper1.ac_register_evt_callback(EventCallback);
    //init Critical Section
    InitializeCriticalSection(critSec);
    //get AMIP version
    GetVersion;
    //reindex playlist
    ReindexPlaylist;
  finally
    StatusBar1.Panels.Items[0].Text := sBuff;
    if sBuff <> 'OK' then
      begin
        SpeedButton1.Enabled := false;
        SpeedButton2.Enabled := false;
        SpeedButton3.Enabled := false;
        SpeedButton4.Enabled := false;
        SpeedButton5.Enabled := false;
        SpeedButton6.Enabled := false;
        SpeedButton7.Enabled := false;
      end;
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  DeleteCriticalSection(critSec);
  AMIPWrapper1.ac_remove_event_listener('127.0.0.1', 60334);
  AMIPWrapper1.ac_uninit;
  AMIPWrapper1.UnloadDLL;
end;

end.
