using System;
using System.Collections.Generic;
using System.Text;

namespace DJMatty.AMIP.ClientWrapper
{
  /// <summary>
  /// Exception is generated by AMIPClient for various reasons
  /// </summary>
  public class AMIPException : Exception
  {
    /// <summary>
    /// Default Constructor
    /// </summary>
    public AMIPException()
      : base()
    {

    }

    /// <summary>
    /// Constructor
    /// </summary>
    /// <param name="message">Text details of the exception</param>
    public AMIPException(string message)
      : base(message)
    {

    }

    /// <summary>
    /// Constructor
    /// </summary>
    /// <param name="message">Text details of the exception</param>
    /// <param name="innerException">Any inner exception that was thrown</param>
    public AMIPException(string message, Exception innerException)
      : base(message, innerException)
    {

    }
  }
}
