/* Shows now playing song title (doesn't link with the lib, uses dynamic loading) */

#include <windows.h>
#include <stdio.h>
#include <string>

// define this to use dynamic DLL loading before including ac.h file
#define AC_DYNAMIC_LOAD

#include "../ac.h"

int main(int argc, char **argv) {
  // you need to initialize dll first
  // note that ac_load_dll() function takes optional argument, a path to the dll
  if (!ac_load_dll()) {
    // you can't call any ac_ function if this has failed, you'll get an exception!
    printf("Can't find ac.dll in PATH or ac.dll version it too old\n");
    return 1;
  }
  // now you can use AMIP SDK as usual

  ac_init(AC_START_CLIENT);

  char np[AC_BUFFER_SIZE];
  // format album like <artist> - <title> [<album>] (<year>)
  if (AC_ERR_NOERROR == ac_format("%name$if2(%4, [%4])$if2(%5, \\(%5\\))", np)) {
    printf("Now playing: %s\n", np);
  } else {
    printf("Error connecting to AMIP Server\n");
  }

  ac_uninit();
  return 0;
}
