/*
 ampy: Date and time display for Launchy
 Copyright (C) 2008  Simon Capewell

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#ifndef ampy_H
#define ampy_H

#include <windows.h>
#include <QtGui>
#include <QFile>
#include <QRegExp>
#include <QEventLoop>
#include <QBuffer>
#include <QString>
#include "plugin_interface.h"

class AmipCommand {
public:
  QString text_command;
  QString api_command;
  QString description;
  AmipCommand(QString cmd, QString api, QString desc):
  text_command(cmd),api_command(api), description(desc){};
};



class ampyPlugin : public QObject, public PluginInterface {
  Q_OBJECT
  Q_INTERFACES(PluginInterface)

public:
  uint HASH_ampy;
  uint HASH_play;
  uint HASH_amip;
  QString libPath;
public:
  ampyPlugin() {
    HASH_ampy = qHash(QString("ampy"));
    HASH_play = qHash(QString("playsong"));
    HASH_amip = qHash(QString("amip"));
    loaded = false;
  }
  ~ampyPlugin();
  int msg(int msgId, void* wParam = NULL, void* lParam = NULL);
  void setPath(QString * path);
  void getID(uint*);
  void getName(QString*);
  void getLabels(QList<InputData>* id);
  void getResults(QList<InputData>* id, QList<CatItem>* results);
  void getCatalog(QList<CatItem>* items);
  void launchItem(QList<InputData>* id, CatItem* item);
  void init();
  QString getIcon();

private:
  bool loaded;
  QList<AmipCommand> commands;
  void addCommand(QString cmd, QString api, QString desc);
  protected slots:
};


#endif
