<?php
# AMIP Dynamic Signature (AMIPDS) v0.4c
# Last modified: 13 December 2004
#
# Author: Serge A. Baranov (AKA CrazyCoder) (coder at tools-for dot net)
# This script is based on the Jigga Jamming's script (http://www.da-shiz.net/jamming/)
# and its modification by James 'theFinn' Atkinson (james@thefinn.net)
#
# Requirements:
#   PHP 4.2.2+
# phpinfo() should report the following GD features:
#   GD Support enabled
#   FreeType Support enabled
#   JPG/PNG Support enabled
#
# You also need AMIP plug-in (http://amip.tools-for.net) to pass song parameters
# to this script

# The following variables must be passed to the script from AMIP to work properly:
#  title (song title, %name in AMIP)
#  album (%4 in AMIP)
#  bitrate (%br in AMIP)
#  time (song length, %min~m:%sec~s in AMIP)
#  mode (Mono/Stereo %typ in AMIP)
#  year (%5 in AMIP)
#  sr (Sampling freq. %sr in AMIP)
#  action=secretword

error_reporting (E_ALL);
unset ($SONG);
unset ($config);
unset ($script_dir);
$config = array();
$SONG = array();
## get the script directory, which is required for fonts
if(isset($_SERVER['SCRIPT_FILENAME'])) {
  $path_parts = pathinfo($_SERVER['SCRIPT_FILENAME']);
  $script_dir = $path_parts['dirname'];
} else {
  $script_dir = '.';
}

# ---------------------------- configuration starts here ---------------------
# Here is how the default signature looks like:

#####################################
# song info            album & year #
#         SONG TITLE CENTERED       #
# Last updated time       AMIP LOGO #
#####################################

# If you dont want any other to update your signature, change this to some secret word
# make sure to pass action=secretword to this script when you are updating signature info
# Read: in amipweb.conf 'action' parameter should be set to the 'secretword' specified here:
$config['action'] = 'secretword';
# Full path of the font used to display the text in the center
# This script tries to get it automatically, however if it doesn't work, set it manually
$config['font_file'] = "$script_dir/impact.ttf";
# Full path of the font used to display text on the sides
$config['font_mono'] = "$script_dir/lucon.ttf";
# File with song information in key=value format
$config['song_file'] = 'npvars.txt';
# Font size of the middle text
$config['font_size'] = 14;
# Font size of the side text
$config['font_monosize'] = 9;
# Color of the main text
$config['font_color'] = '#007878';
# Color of the side text
$config['font_colormono'] = '#8C8C8C';
# The offset from the top
$config['text_vertical_offset'] = 35;
# Offset from left and right
$config['padding'] = 4;
# Padding of the top text from the top of the screen (info and album)
$config['tpadding'] = 1;
# Padding of the bottom text from the bottom of the screen (last updated time)
$config['bpadding'] = 5;
# Base image file name (the background)
$config['image_base'] = 'base_image';
# The extension of the background image (.png or .jpg)
$config['image_ext'] = '.png';
# Convert cyrillic characters to Unicode to be displayed properly
# If you don't have tags with cyrillic, change this to false
$config['cyrillic'] = true;
# Image quality, from 0 to 100, higher - better and larger size
$config['quality'] = 100;
# Write Last updated info in the ago format, like 'X minutes Y seconds ago'.
# If set to false, write the actual date when song info was updated.
# If static generation set to true, then the actual date will be always used
# because ago format requires dynamic generation to calculate the difference
# between current time and last update time and put this info to the image
$config['ago'] = true;
# Last updated date/time format, see strftime documentation for more info
$config['date_format'] = "%d %b, %Y %H:%M %Z";
# Generate static image (.png/.jpg file). If true, the image will be generated every time song changes
# and you can put the link to the .png/.jpg image instead of the script. If you think that your image is
# accessed more frequently than the song changes, then you can set it to true to reduce server
# load, otherwise set it to false and link to the script.
$config['static'] = false;
# Static image path
$config['static_path'] = 'sig' . $config['image_ext'];
# ---------------------------- Configuration end -----------------------------

$generate = !$config['static'];
# If the script is called with action=$config['action'] parameter (from the plug-in),
# save all the passed parameters
if(isset($_REQUEST['action']) && $_REQUEST['action'] == $config['action']) {
  $fp = @fopen($config['song_file'], "w+");
# File opened
  if($fp) {
    foreach($_REQUEST as $key=>$value) {
      if($key != "action") {
        fputs($fp, "$key=$value\n");
      }
    }
    fclose($fp);
# Display error
  } else {
    print("Cannot open file to save variables!");
  }
# We've saved the song info. If static generation is enabled, generate the image, else exit
  if(!$config['static']) {
    exit(0);
  } else {
    $generate = true;
  }
}

# Generate only when song changes if $config['static'] is true
if($generate) {
# If the script is called without action=save parameter, we need to read the song information
# previously saved into song_file, format it and generate cool image

# First we need to get all the song information into $SONG hash for later use.
# song_file has the key=value format, with new line as a separator
  get_song($config['song_file']);

# This will be displayed in the middle of the image, by default we use title

  $song = $SONG['title'];

# No song? Something is set up wrong or the song info was never updated

  if (empty($song)) {
    $song = "No song name found";
  }

# Load background image, we'll then add text to it
# Automatically loads the proper image depending on the extension
  if($config['image_ext'] == '.jpg') {
    $input = imagecreatefromjpeg($config['image_base'] . $config['image_ext']);
  } else if($config['image_ext'] == '.png') {
    $input = imagecreatefrompng($config['image_base'] . $config['image_ext']);
  }
# Get the image size
  $img_size = getimagesize($config['image_base'] . $config['image_ext']);
  $width = $img_size[0];
  $height = $img_size[1];

# Resize the main text (if it is very long to fit the image, reduce the font size)

  $text_size = size_text($config, $song, $img_size);

# Calculate horizontal indent to center the text

  $horiz_indent = (($img_size[0] - $text_size[4]) / 2);

# Create colors which PHP functions can understand

  list($r, $g, $b) = getRGB($config['font_color']);
  $color = imagecolorclosest($input, $r, $g, $b);
  list($r, $g, $b) = getRGB($config['font_colormono']);
  $colormono = imagecolorclosest($input, $r, $g, $b);

# Last updated text is generated from the modification time
# of the file with song variables (npvars.txt)

  $arr = stat($config['song_file']);
  if(!$config['ago'] || $config['static']) {
    $update = strftime($config['date_format'], $arr[9]);
  } else {
    $update = format_ago(time() - $arr[9]);
  }

# Generate the song parameters line, feel free to change it

  $par = "$SONG[time]/$SONG[bitrate]kbps/$SONG[sr]khz/$SONG[mode]";

# Generate the album and year line. If no album is available,
# show AMIP URL in this place

  if(strlen($SONG['album'])>0) {
    $alb = "\"$SONG[album]\"";
    if(strlen($SONG['year'])>0) {
      $alb .= " $SONG[year]";
    }
  } else {
    $alb = "http://amip.tools-for.net";
  }

# Calculate album X position to align it to the right

  $size = imagettfbbox($config['font_monosize'], 0, $config['font_mono'], $alb);
  $albx = $width - ($size[4] - $size[6]) - 5 - $config['padding'];

# Calculate the top text height to properly place it on the top

  $size = imagettfbbox($config['font_monosize'], 0, $config['font_mono'], "Sample text");
  $fh = $size[1] - $size[7];

# Now all the information is ready, add the text to the image

  imagettftext($input,
               $config['font_size'],
               0,              //angle
               $horiz_indent,  //x
               $config['text_vertical_offset'],//y
               $color,
               $config['font_file'],
               $song);

  imagettftext($input,
               $config['font_monosize'],
               0,              //angle
               $config['padding'],  //x
               $height - $config['bpadding'], //y
               $colormono,
               $config['font_mono'],
               "Last updated: " . $update);

  imagettftext($input,
               $config['font_monosize'],
               0,      //angle
               $albx,  //x
               $fh + $config['tpadding'],//y
               $colormono,
               $config['font_mono'],
               $alb);

  imagettftext($input,
               $config['font_monosize'],
               0,              //angle
               $config['padding'],  //x
               $fh + $config['tpadding'],//y
               $colormono,
               $config['font_mono'],
               $par);

}

# If dynamic generation - send headers, otherwise save to file
if(!$config['static']) {
# Send headers
  send_headers();
# Set file to empty
  $file = '';
} else {
  $file = $config['static_path'];
}

# If the image was just generated, save/send it, otherwise read
# the previously generated image from file and send it
if($generate) {
# Send/Save dynamically generated image
  if($config['image_ext'] == '.jpg') {
    imagejpeg($input, $file, $config['quality']);
  } else if($config['image_ext'] == '.png') {
    imagepng($input, $file, ($config['quality'] / 10) - 1);
  }
} else {
# Send from file
  send_headers();
  $fd = fopen($config['static_path'],'r');
  fpassthru($fd);
  fclose($fd);
}

### That's all! ###

#########################
#   Helper functions    #
#########################

function fmtint($n, $word) {
  $out = '';
  if($n > 0) {
    $out .= "$n $word";
    if($n != 1) {
      $out .= 's';
    }
    $out .= ' ';
  }
  return $out;
}

function format_ago($s) {
  $sold = $s;
  $out = '';
  $y = intval($s/31536000);
  $s -= $y*31536000;
  $d = intval($s/86400);
  $s -= $d*86400;
  $h = intval($s/3600);
  $s -= $h*3600;
  $m = intval($s/60);
  $s -= $m*60;

  $out .= fmtint($y, "year");
  $out .= fmtint($d, "day");
  $out .= fmtint($h, "hour");
  $out .= fmtint($m, "minute");
  $out .= fmtint($s, "second");

  if($sold == 0) {
    $out .= "just now!";
  } else {
    $out .= "ago";
  }
  return $out;
}

function send_headers() {
  global $config;
  if($config['image_ext'] == '.png') {
    header ('Content-type: image/png');
  } else {
    header ('Content-type: image/jpeg');
  }
  header ('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
  header ('Expires: Fri, 12 May 1978 12:33:00 GMT');
  header ('Pragma: no-cache');
}

# Resize the text so it fits on the image if the default font
# size is too large.
function size_text(&$config, $song_title, $image_size) {
  $font_size = intval($config['font_size']);
  $padding = intval($config['padding']);
  $text_size = imagettfbbox ($font_size, 0, $config['font_file'], $song_title);
  while($text_size[4] > ($image_size[0] - $padding)) {
    $font_size -= 1;
    $config['text_vertical_offset'] -= 1;
    $text_size = imagettfbbox($font_size, 0, $config['font_file'], $song_title);
  }
  $config['font_size'] = $font_size;
  return (imagettfbbox($font_size, 0, $config['font_file'], $song_title)); //size, angle, name, string
}

function get_song($song_path) {
  global $SONG, $config;
  $contents = file($song_path);
  foreach($contents as $line) {
    $line = rtrim($line);
    list($key, $val) = split("=", $line);
    if($config['cyrillic']) {
      $SONG[$key] = stripslashes(win2uni($val));
    } else {
      $SONG[$key] = stripslashes($val);
    }
  }
}

function getRGB($color) {
  if(substr($color, 0, 1) == "#") {
    $color = substr($color, 1);
  }
  $r = hexdec(substr($color, 0, 2));
  $g = hexdec(substr($color, 2, 2));
  $b = hexdec(substr($color, 4, 2));
  return array($r, $g, $b);
}

function win2uni($winline) {
  $isoline = convert_cyr_string($winline, "w", "i");
  $uniline = "";
  for ($i=0; $i < strlen($isoline); $i++) {
    $thischar=substr($isoline,$i,1);
    $charcode=ord($thischar);
    $uniline.=($charcode>175) ? "&#" . (1040+($charcode-176)). ";" : $thischar;
  }
  return $uniline;
}
?>
