<?php
# AMIP integration by Serge Baranov (c) 2007-2010
# Based on AMIP SDK + PHP bindigs available at:
# http://amip.tools-for.net/wiki/amipdev/downloads

# For the list of preset functions and variables refer to:
# http://amip.tools-for.net/wiki/manual/amip#format_variables

// xstatus and /np command formats:
define("AMIP_XSTATUS", '%name$if2(%4, [%4])$if2(%5, \\(%5\\))');
define("AMIP_NP",      'now playing: %name$if2(%4, [%4])$if2(%5, \\(%5\\))');

// when not playing xStatus will be set to this
$notplaying        = 'Currently no track is playing...';
$enablepopup       = true;

// enable xStatus
$enabled['ICQ']    = true;

// away message settings for protocols
$enabled['YAHOO']  = true;
$enabled['MSN']    = true;
$enabled['AIM']    = true;
$enabled['JABBER'] = true;
$enabled['GG']     = true;

$status['YAHOO']   = 'np: %name';
$status['MSN']     = '(8) %name';
$status['AIM']     = 'np: %name';
$status['JABBER']  = 'np: %name';
$status['GG']      = 'np: %name';

$nostatus['YAHOO'] = '';
$nostatus['MSN']   = '';
$nostatus['AIM']   = '';
$nostatus['JABBER']= '';
$nostatus['GG']    = '';

// remote control settings
$whiteList = array('12467890'); // list of contact UINs in whitelist, separated by commas, like $whiteList=array('123456','759223');
$cmdPrefix = "/ac";

// add your icq protocol names to ICQ_PROTO_NAMES array
//
// examples:
//	$ICQ_PROTO_NAMES = array(
//		'ICQ'
//	);
// or:
//	$ICQ_PROTO_NAMES = array(
//		'ICQ',
//		'ICQ-112233445',
//		'MyICQ'
//	);

/* default */
$ICQ_PROTO_NAMES = array(
  'ICQ'
);


################# DO NOT EDIT ######################

if (!extension_loaded("amip")) {
  if (!dl('php_amip.dll')) return;
}

function mbot_load() {
  global $enabled;
  
  ac_init(AC_START_CLIENT);
  warning("initalized");
  // update custom status
  if($enabled["ICQ"] == 1) {
    updateCustomStatuses();
    mb_SchReg( 'amip', '*/1 * *', 'updateCustomStatuses', 1, 0 );
  }

  updateAwayMsg();
  mb_SchReg("MusicToStatusMessage", "*/1 * *", "updateAwayMsg", 1, 0); // update after every 1 minute (*/1 * *)
  
  mb_SelfRegister(MB_EVENT_SHUTDOWN|MB_EVENT_MSG_OUT|MB_EVENT_MSG_IN,0); //we don't want caching for this event
  
  //hide_console_hack();
}

function mbe_MsgIn($cid,$body,$timestamp,$known) {
  global $whiteList, $cmdPrefix;
  $uin=mb_CGetUIN($cid);
  $isWhite=in_array($uin,$whiteList);
  if(!$isWhite) return 0;
  if(substr($body,0,strlen($cmdPrefix))==$cmdPrefix) {
    $cmd=substr($body,strlen($cmdPrefix)+1);
    warning("cmd: $cmd");
    ac_exec($cmd);
    return 'drop';
  } else {
    return 0;
  }
}

function mbe_MsgOut($cid,$body) {
  global $cmdPrefix;

  if(substr($body,0,3) == '/np') {
    list($res, $title) = ac_format(AMIP_NP);
    if (AC_ERR_NOERROR == $res && strlen($title) > 0) {
      mb_MsgSetBody($title);
      return "send";
    } else {
      mb_PUMsg('AMIP is not configured or no song is playing!',2);
      return 'drop';
    }
  } else if(substr($body,0,strlen($cmdPrefix)) == $cmdPrefix) {
    $cmd=substr($body,strlen($cmdPrefix)+1);
    warning("cmd: $cmd");
    ac_exec($cmd);
    return 'drop';
  }
  return 0;
}

function mbe_ShutDown() 
{ 
  ac_uninit();
}

function get_status() {
  list($rese, $stat) = ac_eval('var_stat');
  if($rese == AC_ERR_NOERROR) return $stat;
  return -1;
}

function makeAwayMsg($text,$protocol) {
  global $nostatus;
  
  list($res, $title) = ac_format($text);
  if (AC_ERR_NOERROR == $res && get_status() == 1) {
    warning('title: ' . $title);
    return $title;
  } else {
    return $nostatus[$protocol];
  }
}

function updateAwayMsg() {
  global $enabled, $status;
  
  warning("updateaway");

  foreach($status as $key => $value) {
    $mbstat = mb_PGetMyStatus($key);
    warning("status for $key is $mbstat");
    
    if($enabled[$key] && ($mbstat != ID_STATUS_OFFLINE)) {
      warning("setting $key");
      mb_PSetMyAwayMsg($key, makeAwayMsg($value,$key));
    }
  }
}

function updateCustomStatuses() {
  //hide_console_hack();
  
  global $ICQ_PROTO_NAMES;
  
  for ($i = 0; $i < count($ICQ_PROTO_NAMES); $i++) {
    // show popup window only for first protocol in array
    updateCustomStatus($ICQ_PROTO_NAMES[$i], $i == 0);
  }
}

function updateCustomStatus($icqProtocolName, $showPopup) {
  global $notplaying, $enablepopup;
  // check if status is "listening to music" else return
  $status = mb_SysCallProtoService( $icqProtocolName, "/GetXStatus", 0, 0 );
  if( $status != 11) {
    return;
  }

  list($res, $title) = ac_format(AMIP_XSTATUS);
  if (AC_ERR_NOERROR == $res) {
    $songtitle = $title;
  } else {
    return; // AMIP is not available
  }

  // check if there is anything playing
  if(get_status() != 1) {
    $songtitle = $notplaying;
  }

  // check if the songtitle changed, return if it hasn't
  $oldsongtitle = mb_CSettingGet( null, $icqProtocolName, 'XStatusMsg' );
  if( $songtitle === $oldsongtitle )
    return;
  
  // now change the statusmessage
  mb_SysCallProtoService( $icqProtocolName, '/SetXStatus', 11, 0 ); // XXX: without this nobody gets notified of your status change
  mb_CSettingSet( null, $icqProtocolName, 'XStatusMsg', $songtitle );
  
  // show a little popup
  if ($enablepopup && $showPopup) {
    $icon_handle = mb_SysCallProtoService( $icqProtocolName, "/GetXStatusIcon", 11, 0 );
    mb_PUAdd( NULL, 'Now Playing:', $songtitle, 0, 0, $icon_handle );
    
    //for debugging
    //mb_Echo( 'Song changed to: '.$songtitle.' (old one was: '.$oldsongtitle.')' . "\n" );
  }
}


function warning( $warningtext ) {
  //mb_Echo( 'AMIP: '.$warningtext . "\n" );
}

?>